//
//  WDVolume.h
//  WDUtility
//
//  Created by bob hahn on 3/5/12.
//  Copyright © 2014 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WDDisk.h"

typedef enum 
{
	unknown,
	HFSPlus,
	ExFat,
    NTFS
} enumvolumeType;

@interface WDVolume : NSObject
{
}

@property (nonatomic, readonly, assign)      io_service_t service;
@property (nonatomic, readwrite, retain)     NSString*   mediaName;
@property (nonatomic, readwrite, retain)     NSString*   volumeName;
@property (nonatomic, readwrite, retain)     NSString*   volumePath;
@property (nonatomic, readwrite, retain)     NSString*   bsdName;
//@property (nonatomic, readwrite, retain)     NSUUID*     uuid;
@property (nonatomic, readwrite, retain)     NSString*   partType;
@property (nonatomic, readwrite, assign)     UInt64      size;
@property (nonatomic, readwrite, assign)     BOOL        writeable;
@property (nonatomic, readwrite, assign)     BOOL        mountable;
@property (nonatomic, readwrite, retain)     NSString*   volumeType;

- (WDVolume *) initWithVolumeName: (char *) objectName withProperties: (NSDictionary *)objectProperties onDisk: (WDDisk *) diskDevice;

- (void)updateVolumeInformation;

- (void) copyMediaName:(NSString **)mediaNamePtr;
- (void) copyVolumeName:(NSString **)volumeNamePtr;
- (void) copyVolumePath:(NSString **)VolumePathPtr;
- (void) copyBSDName:(NSString **)BSDNamePtr;
- (void) copyPartType: (NSString **) partTypePtr;
- (void) getVolumeType: (NSString **) volumeTypePtr;

- (UInt64) getSize;
- (BOOL) getWriteable;
- (BOOL) getMountable;

+(int) setCustomIcon: (NSString *) iconName OnVolume: (NSString *) bsdName;
+(NSString *)getPartitionTypeFromContent: (NSString *) content;

@end
